VERSION 5.00
Object = "{19B7F2A2-1610-11D3-BF30-1AF820524153}#1.1#0"; "ccrpftv6.ocx"
Begin VB.Form Form1 
   Caption         =   "FolderTreeview events"
   ClientHeight    =   3495
   ClientLeft      =   2985
   ClientTop       =   3480
   ClientWidth     =   5100
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3495
   ScaleWidth      =   5100
   Begin CCRPFolderTV6.FolderTreeview FTV1 
      Height          =   1980
      Left            =   240
      TabIndex        =   3
      Top             =   1140
      Width           =   2025
      _ExtentX        =   3572
      _ExtentY        =   3493
      IntegralHeight  =   0   'False
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      ClipControls    =   0   'False
      ForeColor       =   &H80000008&
      Height          =   1905
      Left            =   2520
      TabIndex        =   2
      Top             =   1170
      Width           =   315
   End
   Begin VB.TextBox Text1 
      Height          =   1965
      Left            =   3090
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   1140
      Width           =   1755
   End
   Begin VB.Label Label1 
      Caption         =   "FolderTreeview designtime property settings : Name = ""FTV1"", IntegralHeight = False"
      Height          =   615
      Left            =   240
      TabIndex        =   1
      Top             =   300
      Visible         =   0   'False
      Width           =   3375
   End
   Begin VB.Menu mnuOpts 
      Caption         =   "&Options"
      Begin VB.Menu mnuOptsRoot 
         Caption         =   "&Change Root"
      End
      Begin VB.Menu mnuOptsSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOptsClear 
         Caption         =   "Clear &Output"
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuOptsMouseMove 
         Caption         =   "&MouseMove Event"
         Shortcut        =   ^M
      End
      Begin VB.Menu mnuOptsSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOptsAutoUpdate 
         Caption         =   "&AutoUpdate"
      End
      Begin VB.Menu mnuOptsCheckboxes 
         Caption         =   "Check&boxes"
         Begin VB.Menu mnuOptsCheckboxes1 
            Caption         =   "&None"
         End
         Begin VB.Menu mnuOptsCheckboxes2 
            Caption         =   "Click &select"
         End
         Begin VB.Menu mnuOptsCheckboxes3 
            Caption         =   "Click n&o select"
         End
         Begin VB.Menu mnuOptsCheckboxes4 
            Caption         =   "None &preserve state"
         End
      End
      Begin VB.Menu mnuOptsRefresh 
         Caption         =   "&Refresh"
         Shortcut        =   {F5}
      End
   End
   Begin VB.Menu mnuWindow 
      Caption         =   "&Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindowForm1 
         Caption         =   "&FolderTreeview"
         Enabled         =   0   'False
         Shortcut        =   ^{F1}
      End
      Begin VB.Menu mnuWindowForm2 
         Caption         =   "&VB TreeView"
         Shortcut        =   ^{F2}
      End
      Begin VB.Menu mnuWindowSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuWindowCascade 
         Caption         =   "&Cascade"
      End
      Begin VB.Menu mnuWindowTileHorizontal 
         Caption         =   "Tile &Horizontal"
      End
      Begin VB.Menu mnuWindowTileVertical 
         Caption         =   "Tile &Vertical"
      End
      Begin VB.Menu mnuWindowArrangeIcons 
         Caption         =   "&Arrange Icons"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates the behavior and effect of most of the Events in the
' FolderTreeview control.
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

' Object variable allowing reference to frmBrowseDlg.
Private BrowseDlg As frmBrowseDlg

Private m_hwndTB As Long
Private m_fldr As Folder
Private VSplitter As New CVSplitterWnd
'

Private Sub Form_Load()
    
  ' Get the browse dialog going...
  Set BrowseDlg = frmBrowseDlg

  Set Icon = Nothing
    
  FTV1.TabIndex = 0
  Set m_fldr = FTV1.SelectedFolder
  
  mnuOptsAutoUpdate.Checked = FTV1.AutoUpdate
  Call SetMenuCheckMark(FTV1.CheckBoxes)
  
  m_hwndTB = Text1.hWnd
'  Text1.MultiLine = True
'  Text1.ScrollBars = vbBoth
  Text1 = ""
  
  ' ===============================================
  ' Splitter, required property settings:
  
  KeyPreview = True
  ScaleMode = vbPixels

'  Frame1.Appearance = 0   ' flat
'  Frame1.BorderStyle = vbBSNone   ' hides the caption
'  Frame1.ClipControls = False
  
  With VSplitter
    Call .SetControls(hWnd, GetParent(FTV1.hWnd), Text1.hWnd, Frame1)
    .Left = (ScaleWidth - .Width) * 0.5
'    .Top = 20
    .TrackSplit = True
  End With

End Sub

Private Sub Form_Unload(Cancel As Integer)
'  Set m_fldr = Nothing
End Sub

' ===============================================================
' Menus

Private Sub mnuOptsRoot_Click()

  With BrowseDlg
'    .BrowseMode = bdEverything
    .Owner = MDIForm1
    .Prompt1 = "Select the root folder"
    .RootFolder = .FolderString(ftvDesktop)
    .PreSelectedFolder = FTV1.RootFolder
    If .Browse Then
      Set FTV1.RootFolder = .SelectedFolder
    End If
  End With

End Sub

Private Sub mnuOptsClear_Click()   ' Crtl+C
  Text1 = ""
End Sub

Private Sub mnuOptsMouseMove_Click()   ' Ctrl+M
  mnuOptsMouseMove.Checked = Not mnuOptsMouseMove.Checked
End Sub

Private Sub mnuOptsAutoUpdate_Click()
  mnuOptsAutoUpdate.Checked = Not mnuOptsAutoUpdate.Checked
  FTV1.AutoUpdate = mnuOptsAutoUpdate.Checked
End Sub

Private Sub mnuOptsCheckboxes1_Click()
  FTV1.CheckBoxes = ftvNoCheckboxes
  Call SetMenuCheckMark(ftvNoCheckboxes)
End Sub

Private Sub mnuOptsCheckboxes2_Click()
  FTV1.CheckBoxes = ftvClickSelect
  Call SetMenuCheckMark(ftvClickSelect)
End Sub

Private Sub mnuOptsCheckboxes3_Click()
  FTV1.CheckBoxes = ftvClickNoSelect
  Call SetMenuCheckMark(ftvClickNoSelect)
End Sub

Private Sub mnuOptsCheckboxes4_Click()
  FTV1.CheckBoxes = ftvNoCheckboxesPreserveState
  Call SetMenuCheckMark(ftvNoCheckboxesPreserveState)
End Sub

Private Sub SetMenuCheckMark(dw As ftvCheckBoxesConstants)
  mnuOptsCheckboxes1.Checked = (dw = ftvNoCheckboxes)
  mnuOptsCheckboxes2.Checked = (dw = ftvClickSelect)
  mnuOptsCheckboxes3.Checked = (dw = ftvClickNoSelect)
  mnuOptsCheckboxes4.Checked = (dw = ftvNoCheckboxesPreserveState)
End Sub

Private Sub mnuOptsRefresh_Click()   ' F5
  FTV1.Refresh
End Sub

Private Sub mnuWindow_Click()
  mnuWindowForm2.Enabled = (IsFormLoaded("Form2") = False)
End Sub

Private Sub mnuWindowForm2_Click()   ' Crtl+F2
  Form2.Show
End Sub

Private Sub mnuWindowArrangeIcons_Click()
  MDIForm1.Arrange vbArrangeIcons
End Sub

Private Sub mnuWindowTileVertical_Click()
  MDIForm1.Arrange vbTileVertical
End Sub

Private Sub mnuWindowTileHorizontal_Click()
  MDIForm1.Arrange vbTileHorizontal
End Sub

Private Sub mnuWindowCascade_Click()
  MDIForm1.Arrange vbCascade
End Sub

 ' ===================================================
 ' FolderTreeview events:

Private Sub FTV1_Click()
  AppendText m_hwndTB, "Click"
End Sub

Private Sub FTV1_Collapse(Folder As CCRPFolderTV6.Folder, PreCollapse As Boolean, Cancel As Boolean)
  AppendText m_hwndTB, "Collapse: " & Folder & ", PreCollapse: " & PreCollapse
End Sub

Private Sub FTV1_DblClick()
  AppendText m_hwndTB, "DblClick"
End Sub

Private Sub FTV1_DragDrop(Source As Control, x As Single, y As Single)
  AppendText m_hwndTB, "DragDrop: " & Source.Name & ", " & x & ", " & y
End Sub

Private Sub FTV1_DragOver(Source As Control, x As Single, y As Single, State As Integer)
  AppendText m_hwndTB, "DragOver: " & Source.Name & ", " & x & ", " & y & ", " & State
End Sub

Private Sub FTV1_Expand(Folder As CCRPFolderTV6.Folder, PreExpand As Boolean, Cancel As Boolean)
  AppendText m_hwndTB, "Expand: " & Folder & ", PreExpand: " & PreExpand
End Sub

Private Sub FTV1_FolderClick(Folder As CCRPFolderTV6.Folder, Location As CCRPFolderTV6.ftvHitTestConstants)
'  FTV1.SelectedFolder.Selected = False
'  AppendText m_hwndTB, "old folder: " & m_fldr
'  Set m_fldr = Folder
  AppendText m_hwndTB, "FolderClick: " & Folder & ", " & GetFolderElementStr(Location)
  AppendText m_hwndTB, "Shell attributes: &H" & Hex(Folder.Attributes)
End Sub

Private Function GetFolderElementStr(Location As CCRPFolderTV6.ftvHitTestConstants) As String
  Dim sLocation As String

  Select Case Location
    Case ftvOnFolderIndent:       sLocation = "on indent"
    Case ftvOnFolderCheckBox: sLocation = "on checkbox"
    Case ftvOnFolderButton:       sLocation = "on button"
    Case ftvOnFolderIcon:          sLocation = "on icon"
    Case ftvOnFolderLabel:        sLocation = "on label"
    Case ftvOnFolderRight:        sLocation = "on right"
    Case ftvOnFolder:                 sLocation = "on folder"
    Case Else:                            sLocation = "on ??"
  End Select

  GetFolderElementStr = sLocation

End Function

Private Sub FTV1_FolderUpdate(FolderName As String, EventID As CCRPFolderTV6.ftvFolderUpdateConstants)
  Dim sEvent As String

  Select Case EventID
    Case ftvFolderCreated: sEvent = "ftvFolderCreated"
    Case ftvFolderRemoved: sEvent = "ftvFolderRemoved"
    Case ftvMediaInserted: sEvent = "ftvMediaInserted"
    Case ftvMediaRemoved: sEvent = "ftvMediaRemoved"
    Case ftvDriveRemoved: sEvent = "ftvDriveRemoved"
    Case ftvDriveAdded: sEvent = "ftvDriveAdded"
    Case ftvNetworkShareAdded: sEvent = "ftvNetworkShareAdded"
    Case ftvNetworkShareRemoved: sEvent = "ftvNetworkShareRemoved"
    Case ftvFolderContentsUpdated: sEvent = "ftvFolderContentsUpdated"
    Case ftvNetworkServerDisconnected: sEvent = "ftvNetworkServerDisconnected"
    Case ftvImageUpdated: sEvent = "ftvImageUpdated"
    Case ftvDriveIconAdded: sEvent = "ftvDriveIconAdded"
    Case ftvFolderRenamed: sEvent = "ftvFolderRenamed"
  End Select

  AppendText m_hwndTB, "FolderUpdate: " & sEvent & ", " & FolderName

End Sub

Private Sub FTV1_GotFocus()
  AppendText m_hwndTB, "GotFocus"
End Sub

Private Sub FTV1_HScroll()
  AppendText m_hwndTB, "HScroll"
End Sub

Private Sub FTV1_KeyDown(KeyCode As Integer, Shift As Integer)
  AppendText m_hwndTB, "KeyDown: " & KeyCode & ", " & Shift
End Sub

Private Sub FTV1_KeyPress(KeyAscii As Integer)
  AppendText m_hwndTB, "KeyPress: " & KeyAscii
End Sub

Private Sub FTV1_KeyUp(KeyCode As Integer, Shift As Integer)
  AppendText m_hwndTB, "KeyUp: " & KeyCode & ", " & Shift
End Sub

Private Sub FTV1_LostFocus()
  AppendText m_hwndTB, "LostFocus"
End Sub

Private Sub FTV1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  AppendText m_hwndTB, "MouseDown: " & Button & ", " & Shift & ", " & x & ", " & y
End Sub

Private Sub FTV1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
  Dim fldr As Folder
  Dim area As ftvHitTestConstants
  
  If mnuOptsMouseMove.Checked Then
    AppendText m_hwndTB, "MouseMove: " & Button & ", " & Shift & ", " & x & ", " & y
    Set fldr = FTV1.HitTest(, , area)
    If (fldr Is Nothing) = False Then
      AppendText m_hwndTB, "HitTest: " & fldr & ", " & GetFolderElementStr(area)
    End If
  End If

End Sub

Private Sub FTV1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
  AppendText m_hwndTB, "MouseUp: " & Button & ", " & Shift & ", " & x & ", " & y
End Sub

Private Sub FTV1_SelectionChange(Folder As CCRPFolderTV6.Folder, PreChange As Boolean, Cancel As Boolean)
  AppendText m_hwndTB, "SelectionChange: " & Folder & ", PreChange: " & PreChange & ", SelectedFolder: " & FTV1.SelectedFolder
End Sub

Private Sub FTV1_VScroll()
  AppendText m_hwndTB, "VScroll"
End Sub

' ===============================================================
' Splitter

Private Sub Form_Resize()
  ' No resize when minimized...
  If WindowState <> vbMinimized Then Call VSplitter.AdjustSplitterPosition(True)
End Sub

Private Sub Frame1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  If Button = vbLeftButton Then Call VSplitter.BeginSplit(x, y)
End Sub

Private Sub Frame1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.MoveSplitter(x, y)
End Sub

Private Sub Frame1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.EndSplit(x, y, True)
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  If (KeyCode = vbKeyEscape) And VSplitter.Splitting Then Call VSplitter.CancelSplit
End Sub
